% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{find_leg}
\alias{find_leg}
\title{Find best non-stop route between 2 airports}
\usage{
find_leg(
  ac,
  ap2,
  route_grid,
  fat_map,
  ap_loc,
  avoid = NA,
  enforce_range = TRUE,
  best_by_time = TRUE,
  grace_km = NA,
  shortcuts = TRUE,
  ad_dist_m = 100 * 1000,
  ad_nearest = 12,
  max_leg_circuity = 1.4,
  ...
)
}
\arguments{
\item{ac, ap2, route_grid, fat_map, ap_loc, avoid}{See \code{\link{find_route}}}

\item{enforce_range}{If TRUE (default) then leg is constrained to aircraft range,
otherwise routes of excess range can be found.}

\item{best_by_time}{If TRUE (default) then the quickest route is found,
else the shortest distance.}

\item{grace_km}{Default NA. Otherwise, if great circle distance is within
3pct of aircraft range, then add \code{grace_km}km to the range.}

\item{shortcuts}{If TRUE (default) then path will be checked for great circle shortcuts.}

\item{ad_dist_m}{The length of arrival/departure links, in m. (Default 100,000=100km)}

\item{ad_nearest}{The number of arrival/departure links to create (Default 12)}

\item{max_leg_circuity}{The maximum detour over great circle distance that
can be flown to find a quick over-sea route. Default 1.4.}

\item{...}{Other parameters, passed to \code{\link{make_route_envelope}}}
}
\value{
Dataframe with details of the leg
}
\description{
\code{find_leg} finds the quickest non-stop route for \code{ac} between
two airports \code{ap2}.
}
\details{
This function finds the quickest non-stop route between two airports. A
'route' is made up of one or two 'legs' (airport to airport without
intermediate stop). \code{\link{find_route}} makes one or more calls to
\code{find_leg} as required.

It assumes that the routing grid, \code{route_grid}, has already been classified as
land or sea using the map \code{fat_map}. The map is further used when
converting the grid-based route to one of great-circle segments.

In fact \code{find_leg} finds up to 4 versions of the path:
\enumerate{
    \item A great circle, direct between the airports
    \item A grid path, consisting of segments of the routing grid, plus departure
    and arrival routes from the airports
    \item A simplification of the grid path to great circle segments
    \item \code{shortcuts} defaults to TRUE. Without this, you see near-raw
    Dijkstra results, which are _not_ shortest great circle.
}

Legs are automatically saved in \code{route_cache} and retrieved from here if
available rather than re-calculated. See
\href{../doc/Supersonic_routes_in_depth.html#cache}{vignette on caching} for cache
management.
}
\examples{
# need to load some of the built-in data (not run)
\dontrun{
aircraft <- make_aircraft(warn = FALSE)
airports <- make_airports(crs = crs_Pacific)
# get test datasets
NZ_buffer30 <- hm_get_test("buffer")
NZ_grid <- hm_get_test("grid")

options("himach.verbosity" = 4) #for heavy reporting
# from Auckland to Christchurch
ap2 <- make_AP2("NZAA","NZCH",airports)
routes <- find_leg(aircraft[4,],
                    ap2,
                    fat_map = NZ_buffer30,
                    route_grid = NZ_grid,
                    ap_loc = airports)
}
}
