% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{summarise_routes}
\alias{summarise_routes}
\title{Summarise a set of routes}
\usage{
summarise_routes(routes, ap_loc, arrdep_h = 0.5)
}
\arguments{
\item{routes}{Each segment in each route, as produced by
\code{\link{find_route}} or \code{\link{find_leg}}}

\item{ap_loc}{List of airport locations, output of
\code{\link{make_airports}}}

\item{arrdep_h}{Total time for the M084 comparator aircraft to arrive &
depart in hours. Default 0.5.}
}
\value{
Dataframe with summary of the route, sorted in ascending order of \code{advantage_h}
so that the best route are plotted on top. The fields are:
\itemize{
  \item \code{timestamp}: when the leg was originally generated (it may have been cached)
  \item \code{fullRouteID}: including the refuel stop if any
  \item \code{routeID}: origin and destination airport, in \code{\link{make_AP2}} order
  \item \code{refuel_ap}: code for the refuelling airport, or NA
  \item \code{acID, acType}: aircraft identifiers taken from the aircraft set
  \item \code{M084_h}: flight time for a Mach 0.84 comparator aircraft (including \code{2*arrdep_h})
  \item \code{gcdist_km}: great circle distance between the origin and destination airports
  \item \code{sea_time_frac}: Fraction of \code{time_h} time spent over sea, hence at supersonic speed,
    or accelerating to, or decelerating from supersonic speed
  \item \code{sea_dist_frac}: as sea_time_frac, but fraction of \code{dist_km}
  \item \code{dist_km}: total length of the route, in km
  \item \code{time_h}: total time, in hours
  \item \code{n_phases}: number of distinct phases: arr/dep, transition, land, sea, refuel.
  \item \code{advantage_h}: \code{M084_h - time_h}

  \item \code{circuity}: the route distance extension (1 = perfect) \code{dist_km / gcdist_km}
  \item \code{best}: for each \code{routeID}, the \code{fullrouteID} with maximum \code{advantage_h}
}
}
\description{
Reduce a set of routes to a one-line per route summary
}
\details{
This function takes the output of \code{\link{find_route}} and summarises to
one line per (full) route.

With refuelling, there can be multiple 'full routes' for each 'route'. The
\code{best} column indicates the best route for each \code{routeID}.

The results are rounded to a reasonable number of significant figures. After
all this is just an approximate model. The \code{arrdep_h} has been checked
against actual and is reasonable (observed range roughly 0.3-0.5).
}
\examples{
# here we use a built-in set of routes
# see vignette for more details of how to obtain it
airports <- make_airports(crs = crs_Pacific)
sumy <- summarise_routes(NZ_routes, airports)

}
