% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.incidence.R
\name{to.incidence}
\alias{to.incidence}
\title{Hill numbers computation}
\usage{
to.incidence(otutable, hierarchy, relative)
}
\arguments{
\item{otutable}{A matrix/data.frame indicating the (relative) abundances of multiple samples. Columns must refer to samples and rows to OTUs/ASVs.}

\item{hierarchy}{A two-column matrix indicating the relation between samples (first column) and groups (second column).}

\item{relative}{Whether to transform the incidence vector or matrix to relative (0-1) values. Default: relative=FALSE.}
}
\value{
A vector of incidence data of a single system if no hierarchy table is specified and a matrix of incidence data of multiple systems if a hierarchy table is specified.
}
\description{
Transform a count (OTU/ASV) table from abundance to incidence.
}
\details{
To incidence
}
\examples{
data(bat.diet.otutable)
data(bat.diet.hierarchy)
to.incidence(bat.diet.otutable)
to.incidence(bat.diet.otutable,bat.diet.hierarchy)
to.incidence(bat.diet.otutable,bat.diet.hierarchy,relative=TRUE)
to.incidence(otutable=bat.diet.otutable,hierarchy=bat.diet.hierarchy,relative=TRUE)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.
}
\seealso{
\code{\link{hill_div}}, \code{\link{div_part}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{ASV}
\keyword{OTU}
\keyword{abundance}
\keyword{hill}
\keyword{table}
