% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{aggregateTS}
\alias{aggregateTS}
\title{Aggregate a time series}
\usage{
aggregateTS(
  ts,
  FUN = "previoustick",
  on = "minutes",
  k = 1,
  weights = NULL,
  dropna = FALSE,
  tz = NULL
)
}
\arguments{
\item{ts}{xts object to aggregate.}

\item{FUN}{function to apply over each interval. By default, previous tick aggregation is done. 
Alternatively one can set e.g. FUN = "mean".
In case weights are supplied, this argument is ignored and a weighted average is taken.}

\item{on}{character, indicating the time scale in which "k" is expressed. Possible values are: "secs", "seconds", "mins", "minutes", "hours", "days", "weeks", "ticks".}

\item{k}{positive integer, indicating the number of periods to aggregate over. For example, to aggregate an 
xts object to the five-minute frequency set k = 5 and on = "minutes".}

\item{weights}{By default, no weighting scheme is used. 
When you assign an xts object with wheights to this argument, a weighted mean is taken over each interval. 
Of course, the weights should have the same timestamps as the supplied time series.}

\item{dropna}{boolean, which determines whether empty intervals should be dropped.
By default, an NA is returned in case an interval is empty, except when the user opts
for previous tick aggregation, by setting FUN = "previoustick" (default).}

\item{tz}{character denoting which timezone the output should be in. Defaults to "GMT"}
}
\value{
An xts object containing the aggregated time series.
}
\description{
Function returns aggregated time series as xts object. 
It can handle irregularly spaced timeseries and returns a regularly spaced one.
Use univariate timeseries as input for this function, and check out \code{\link{aggregateTrades}}
and \code{\link{aggregateQuotes}} to aggregate Trade or Quote data objects.
}
\details{
The timestamps of the new time series are the closing times and/or days of the intervals. 
E.g. for a weekly aggregation the new timestamp is the last day in that particular week (namely sunday).

In case of previous tick aggregation, 
for on = "seconds"/"minutes"/"hours",
the element of the returned series with e.g. timestamp 09:35:00 contains 
the last observation up to that point, including the value at 09:35:00 itself.

Please note: In case an interval is empty, by default an NA is returned.. In case e.g. previous 
tick aggregation it makes sense to fill these NA's by the function \code{na.locf}
(last observation carried forward) from the zoo package.

In case on = "ticks", the sampling is done such the sampling starts on the first tick, and the last tick is always included
For example, if 14 observations are made on one day, and these are 1, 2, 3, ... 14.
Then, with on = "ticks" and k = 3, the output will be 1, 4, 7, 10, 13, 14.
}
\examples{
#load sample price data
ts <- sampleTData$PRICE

#Previous tick aggregation to the 5-minute sampling frequency:
tsagg5min <- aggregateTS(ts, on = "minutes", k = 5)
head(tsagg5min)
#Previous tick aggregation to the 30-second sampling frequency:
tsagg30sec <- aggregateTS(ts, on = "seconds", k = 30)
tail(tsagg30sec)

tsagg3ticks <- aggregateTS(ts, on = "ticks", k = 3)

}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{data}
\keyword{manipulation}
