% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{tradesCleanup}
\alias{tradesCleanup}
\title{Cleans trade data}
\usage{
tradesCleanup(datasource = NULL, datadestination = NULL, exchanges,
  tdataraw = NULL, report = TRUE, selection = "median",
  saveasxts = TRUE)
}
\arguments{
\item{datasource}{character indicating the folder in which the original data is stored.}

\item{datadestination}{character indicating the folder in which the cleaned data is stored.}

\item{exchanges}{list of vectors of stock exchange(s) for all tickers in vector "ticker". It thus should have the same length as the vector ticker.
E.g. in case of two stocks; exchanges = list("N", c("Q","T")).
The possible exchange symbols are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
}}

\item{tdataraw}{xts object containing (for ONE stock only) raw trade data. This argument is NULL by default. Enabling it means the arguments
from, to, datasource and datadestination will be ignored. (only advisable for small chunks of data)}

\item{report}{boolean and TRUE by default. In case it is true the function returns (also) a vector indicating how many trades remained after each cleaning step.}

\item{selection}{argument to be passed on to the cleaning routine \code{\link{mergeTradesSameTimestamp}}. The default is "median".}

\item{saveasxts}{indicates whether data should be saved in xts format instead of data.table when using on-disk functionality. TRUE by default.}
}
\value{
For each day an xts or data.table object is saved into the folder of that date, containing the cleaned data.
This procedure is performed for each stock in "ticker".
The function returns a vector indicating how many trades remained after each cleaning step.

In case you supply the argument "rawtdata", the on-disk functionality is ignored
and the function returns a list with the cleaned trades as xts object (see examples).
}
\description{
This is a wrapper function for cleaning the trade data of all stock data inside the folder datasource. 
The result is saved in the folder datadestination. 

In case you supply the argument "rawtdata", the on-disk functionality is ignored. The function returns a vector
indicating how many trades were removed at each cleaning step in this case.
and the function returns an xts or data.table object.

The following cleaning functions are performed sequentially:
\code{\link{noZeroPrices}}, \code{\link{selectExchange}}, \code{\link{salesCondition}},
\code{\link{mergeTradesSameTimestamp}}.

Since the function \code{\link{rmTradeOutliersUsingQuotes}}
also requires cleaned quote data as input, it is not incorporated here and
there is a seperate wrapper called \code{\link{tradesCleanupUsingQuotes}}.
}
\examples{
# Consider you have raw trade data for 1 stock for 2 days 
head(sample_tdataraw_microseconds)
dim(sample_tdataraw_microseconds)
tdata_afterfirstcleaning <- tradesCleanup(tdataraw = sample_tdataraw, exchanges = list("N"))
tdata_afterfirstcleaning$report
dim(tdata_afterfirstcleaning$tdata)

#In case you have more data it is advised to use the on-disk functionality
#via "from","to","datasource",etc. arguments

}
\references{
Barndorff-Nielsen, O. E., P. R. Hansen, A. Lunde, and N. Shephard (2009). Realized kernels in practice: Trades and quotes. Econometrics Journal 12, C1-C32.

Brownlees, C.T. and Gallo, G.M. (2006). Financial econometric analysis at ultra-high frequency: Data handling concerns. Computational Statistics & Data Analysis, 51, pp. 2232-2245.
}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{cleaning}
