% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-hc_add_series-deprecated.R
\name{hc_add_series_scatter}
\alias{hc_add_series_scatter}
\title{Shortcut  for create scatter plots}
\usage{
hc_add_series_scatter(hc, x, y, z = NULL, color = NULL, label = NULL,
  showInLegend = FALSE, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{x}{A numeric vector.}

\item{y}{A numeric vector. Same length of \code{x}.}

\item{z}{A numeric vector for size. Same length of \code{x}.}

\item{color}{A vector to color the points.}

\item{label}{A vector to put names in the dots if you enable the datalabels.}

\item{showInLegend}{Logical value to show or not the data in the legend box.}

\item{...}{Additional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function helps to create scatter plot from two numerics vectors. Options
arguments like size, color and label for points are added.
}
\examples{

\dontrun{
hc <- highchart()

hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg)
hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg, mtcars$drat)
hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg, mtcars$drat, mtcars$am)
hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg, mtcars$drat, mtcars$qsec)
hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg, mtcars$drat, mtcars$qsec, rownames(mtcars))

# Add named attributes to data (attributes length needs to match number of rows)
hc_add_series_scatter(hc, mtcars$wt, mtcars$mpg, mtcars$drat, mtcars$qsec,
                      name = rownames(mtcars), gear = mtcars$gear) \%>\%
  hc_tooltip(pointFormat = "<b>{point.name}</b><br/>Gear: {point.gear}")
  
}

}
