% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlhighCox.R
\name{mlhighCox}
\alias{mlhighCox}
\title{mlhighCox}
\usage{
mlhighCox(cols, idSurv, idEvent, per = 20, fold = 3, data)
}
\arguments{
\item{cols}{A numeric vector of column numbers indicating the features for which the log Loss functions are to be computed}

\item{idSurv}{The name of the survival time variable}

\item{idEvent}{The name of the survival event variable}

\item{per}{Percentage of total features to be selected, default value 20}

\item{fold}{An integer denoting number of folds in cross validation, default value 3}

\item{data}{A data frame that contains the survival and covariate information for the subjects}
}
\value{
A dataframe containing desired number of features and the corresponding log Loss function.
}
\description{
This function extracts desired number of features based on minimum log-Loss function
using Cox proportional hazard model as learner method on a high dimensional survival data.
}
\details{
Performs feature Selection using Cox PH on high-dimensional data

Using the Cox proportional hazard model on the given survival data, this function selects
the most significant feature based on a performance measure. The performance measure is considered as logarithmic loss function. It is defined as,
\deqn{L(f,t)=-log(f(t))}. The features with minimum log-loss function are extracted.
}
\examples{
\donttest{
data(hnscc)
mlhighCox(cols=c(6:15), idSurv="OS", idEvent="Death", per=20, fold = 3, data=hnscc)
}
}
\references{
Sonabend, R., Király, F. J., Bender, A., Bernd Bischl B. and Lang M. mlr3proba: An R Package for Machine Learning in Survival Analysis, 2021, Bioinformatics, <https://doi.org/10.1093/bioinformatics/btab039>
}
\seealso{
mlhighKap, mlhighFrail
}
\author{
Atanu Bhattacharjee, Gajendra K. Vishwakarma & Souvik Banerjee
}
