% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_grid_cell_to_lonlat}
\alias{hexify_grid_cell_to_lonlat}
\title{Convert cell ID to longitude/latitude using a grid object}
\usage{
hexify_grid_cell_to_lonlat(grid, cell_id)
}
\arguments{
\item{grid}{Grid specification from hexify_grid()}

\item{cell_id}{Numeric vector of cell IDs (1-based)}
}
\value{
Data frame with lon_deg and lat_deg columns
}
\description{
Grid-based wrapper for \code{\link{hexify_cell_to_lonlat}}. Converts
DGGRID-compatible cell IDs back to cell center coordinates
using the resolution and aperture from a grid object.
}
\examples{
grid <- hexify_grid(area = 1000, aperture = 3)
cell_ids <- hexify_grid_to_cell(grid, lon = 5, lat = 45)
coords <- hexify_grid_cell_to_lonlat(grid, cell_ids)
}
\seealso{
\code{\link{cell_to_lonlat}} for the recommended S4 interface,
\code{\link{hexify_grid_to_cell}} for the forward operation

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
