% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heumilkr_solution.R
\name{milkr_saving}
\alias{milkr_saving}
\title{Vehicle run saving}
\usage{
milkr_saving(solution, relative = FALSE)
}
\arguments{
\item{solution}{A "\code{heumilkr_solution}" object, typically obtained by \code{\link[=clarke_wright]{clarke_wright()}}.}

\item{relative}{Should the saving be given as dimensionful value (in units of distance as
provided to \code{\link[=clarke_wright]{clarke_wright()}}), or as percentage relative to the
naive costs.
Defaults to \code{FALSE}, i.e. a dimensionful value.}
}
\value{
The savings either as dimensionful value or as percentage relative to the
naive costs, depending on \code{relative}.
}
\description{
Measures the saving that was achieved by the heuristic optimization
algorithm \code{\link[=clarke_wright]{clarke_wright()}} compared to the naive vehicle run assignment,
i.e. one run per site.
}
\examples{
demand <- c(3, 2, 4, 2)

positions <-
  data.frame(
    pos_x = c(0, 1, -1, 2, 3),
    pos_y = c(0, 1, 1, 2, 3)
  )

solution <- clarke_wright(
  demand,
  dist(positions),
  data.frame(n = NA_integer_, caps = 6)
)

print(milkr_saving(solution))
print(milkr_saving(solution, relative = TRUE))

}
