% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statevals.R
\name{sim_ev}
\alias{sim_ev}
\alias{sim_qalys}
\alias{sim_costs}
\title{Expected values}
\usage{
sim_qalys(object, utility_model, dr, method, lys)

sim_costs(object, cost_models, dr, method)
}
\arguments{
\item{object}{A \link{stateprobs} object.}

\item{utility_model}{A single object of class \link{StateVals} used
to simulate utility.}

\item{dr}{Discount rate.}

\item{lys}{If \code{TRUE}, then life-years are simulated in addition to
QALYs.}

\item{cost_models}{A list of objects of class \link{StateVals} used
to simulate costs.}

\item{integrate_method}{Method used to integrate state values when computing
weighted length of stay. Options are \code{trapz} for the trapezoid rule,
\code{riemann_left} left for a left Riemann sum, and
\code{riemann_right} right for a right Riemann sum.}
}
\value{
\code{\link[=sim_costs]{sim_costs()}} and \code{\link[=sim_qalys]{sim_qalys()}} return objects of class
\link{costs} and \link{qalys}, respectively.
}
\description{
Simulate costs and quality-adjusted life-years (QALYs) as a function of
simulated state occupancy probabilities.
}
\details{
See \code{vignette("expected-values")} for details.
}
\keyword{internal}
