% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findLocation.R
\name{findLocation}
\alias{findLocation}
\title{Find host-parasite interactions for a given location}
\usage{
findLocation(location = NULL, group = NULL, citation = FALSE,
  hostState = NULL, speciesOnly = FALSE, validateHosts = FALSE,
  removeDuplicates = FALSE)
}
\arguments{
\item{location}{Location of host-parasite interaction.}

\item{group}{Parasite group - Cestodes, Acanthocephalans, Monogeneans, 
Nematodes, Trematodes, or Turbellarian etc. (Turb)}

\item{citation}{Boolean. Should the output include the citation link and 
the number of supporting citations? default is FALSE}

\item{hostState}{number corresponding to one of six different host states. 
The default value is NULL and includes all host states.}

\item{speciesOnly}{boolean flag to remove host and parasite species
where data are only available at genus level (default = FALSE)}

\item{validateHosts}{boolean flag to check host species names
against Catalogue of Life information and output taxonomic
information (default = FALSE)}

\item{removeDuplicates}{(boolean) should duplicate host-parasite 
combinations be removed? (default is FALSE)}
}
\value{
Three (or five) column data.frame containing host species, 
	parasite species (shortened name and full name), and citation link and 
	number of citations (if `citation`=TRUE), with each row corresponding 
	to an occurrence of a parasite species on a host species.
}
\description{
Given a location (available from \code{\link{listLocations}} this function 
	returns all host-parasite associations in that location.
}
\details{
\code{hostState} can take values 1-6 corresponding to if the recorded 
	host was found 
\itemize{ 
	\item (1) "In the wild"
	\item (2) "Zoo captivity" 
	\item (3) "Domesticated"
	\item (4) "Experimental"
	\item (5) "Commercial source"
	\item (6) "Accidental infestation"
 }
}
\examples{
\donttest{ FrenchHostPars <- helminthR::findLocation(location="France")}
}
\references{
Gibson, D. I., Bray, R. A., & Harris, E. A. (Compilers) (2005).
Host-Parasite Database of the Natural History Museum, London.
<http://www.nhm.ac.uk/research-curation/scientific-resources/taxonomy-systematics/host-parasites/>
}
\seealso{
\code{\link{findHost}}
}
\author{
Tad Dallas
}
