% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_page_hinkley.R
\name{dfr_page_hinkley}
\alias{dfr_page_hinkley}
\title{Adapted Page Hinkley method}
\usage{
dfr_page_hinkley(
  target_feat,
  min_instances = 30,
  delta = 0.005,
  threshold = 50,
  alpha = 1 - 1e-04
)
}
\arguments{
\item{target_feat}{Feature to be monitored.}

\item{min_instances}{The minimum number of instances before detecting change}

\item{delta}{The delta factor for the Page Hinkley test}

\item{threshold}{The change detection threshold (lambda)}

\item{alpha}{The forgetting factor, used to weight the observed value and the mean}
}
\value{
\code{dfr_page_hinkley} object
}
\description{
Change-point detection method works by computing the observed values and their mean up to the current moment \url{doi:10.2307/2333009}.
}
\examples{
require("daltoolbox")
require('ggplot2')
require('caret')

data("st_real_examples")

bfd <- st_real_examples$bfd1
bfd['batch_index'] <- format(bfd['expected_depart'], '\%V')
bfd <- bfd[bfd['depart'] == 'SBSP',]

# Model features
features <- c(
 'depart_elevation', 'depart_visibility', 'depart_day_period', 'depart_pressure', 
 'depart_relative_humidity', 'depart_dew_point', 'depart_wind_speed_scale'
)

## Target
bfd$delay_depart_bin <- bfd$delay_depart > 0
target = 'delay_depart_bin'
bfd = bfd[complete.cases(bfd[target]),]
slevels <- c(TRUE, FALSE)

# Evaluation
th=0.5

results <- c()
ordered_batches <- sort(unique(bfd$batch_index))
old_start_batch <- ordered_batches[1]

# Classification Algorithm
model <- stealthy(daltoolbox::cla_nb(target, slevels), 
dfr_page_hinkley(target_feat='depart_visibility'))

for (batch in ordered_batches[2:length(ordered_batches)]){
 print(batch)
 print(old_start_batch)
 
 new_batch <- bfd[bfd$batch_index == batch,]
 last_batch <- bfd[(bfd$batch_index < batch) & (bfd$batch_index >= old_start_batch),]
 
 old_start_batch <- batch
 
 x_train <- last_batch[, features]
 y_train <- last_batch[, target, drop=FALSE]
 
 x_test <- new_batch[, features]
 y_test <- new_batch[, target]
 
 model <- fit(model, x_train, y_train)
 
 test_predictions <- predict(model, x_test)
 y_pred <- test_predictions[, 2] > th
 
 # Evaluation
 precision <- evaluate(mt_precision(), y_pred, y_test)
 recall <- evaluate(mt_recall(), y_pred, y_test)
 f1 <- evaluate(mt_fscore(), y_pred, y_test)
 
 results <- rbind(results, 
                  c(
                    batch,
                    precision,
                    recall,
                    f1,
                    model$drifted
                  )
 )
 
 print(nrow(model$x_train))
 print(nrow(new_batch))
}
results <- as.data.frame(results)
results['index'] <- as.Date(results$index)
names(results) <- c('index', 'precision', 'recall', 'f1', 'drift')
results[, length(names(results))] <- NULL

ggplot(data=results, aes(x=index, y=as.numeric(f1), group=1)) + 
 geom_line() +
 xlab('') +
 ylab('F1') +
 geom_vline(xintercept = results[results['drift']==TRUE, 'index'],
            linetype="dotted", 
            color = "red", linewidth=0.5) +
 theme_classic()

}
