% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-cms-meta-data.R
\name{get_cms_meta_data}
\alias{get_cms_meta_data}
\title{Retrieve CMS Metadata Links from CMS}
\usage{
get_cms_meta_data(
  .title = NULL,
  .modified_date = NULL,
  .keyword = NULL,
  .identifier = NULL,
  .data_version = "current",
  .media_type = "all"
)
}
\arguments{
\item{.title}{This can be a title that is used to search the data.}

\item{.modified_date}{This can be a date in the format of "YYYY-MM-DD"}

\item{.keyword}{This can be a keyword that is used to search the data.}

\item{.identifier}{This can be an identifier that is used to search the data.}

\item{.data_version}{This can be one of three different choices: "current",
"archive", or "all". The default is "current" and if you make a choice that
does not exist then it will default to "current".}

\item{.media_type}{This can be one of three different choices: "all", "csv",
"API", or "other". The default is "all" and if you make a choice that does not
exist then it will default to "all".}
}
\value{
A tibble with data links and relevant metadata about the datasets.
}
\description{
This function sends a request to the specified CMS data URL, retrieves the JSON data,
and processes it to create a tibble with relevant information about the datasets.
}
\details{
The function fetches JSON data from the CMS data URL and extracts relevant fields to
create a tidy tibble. It selects specific columns, handles nested lists by unnesting them,
cleans column names, and processes dates and media types to make the data more useful for analysis.
The columns in the returned tibble are:
\itemize{
\item \code{title}
\item \code{description}
\item \code{landing_page}
\item \code{modified}
\item \code{keyword}
\item \code{described_by}
\item \code{fn}
\item \code{has_email}
\item \code{identifier}
\item \code{start}
\item \code{end}
\item \code{references}
\item \code{distribution_description}
\item \code{distribution_title}
\item \code{distribution_modified}
\item \code{distribution_start}
\item \code{distribution_end}
\item \code{media_type}
\item \code{data_link}
}
}
\examples{
library(dplyr)

# Fetch and process metadata from the CMS data URL
get_cms_meta_data(
  .keyword = "nation",
  .title = "Market Saturation & Utilization State-County"
) |>
  glimpse()

}
\seealso{
\url{https://data.cms.gov/data.json}

Other Meta Data: 
\code{\link{get_provider_meta_data}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Meta Data}
