% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdru.R
\name{mdru}
\alias{mdru}
\title{Mean difference from a reference subgroup (unweighted) (MDRU)}
\usage{
mdru(
  est,
  se = NULL,
  scaleval,
  reference_subgroup,
  sim = NULL,
  seed = 123456,
  ...
)
}
\arguments{
\item{est}{The subgroup estimate.
Estimates must be available for all subgroups.}

\item{se}{The standard error of the subgroup estimate.
If this is missing, 95\% confidence intervals of MDRU cannot be calculated.}

\item{scaleval}{The scale of the indicator. For example, the
scale of an indicator measured as a percentage is 100. The
scale of an indicator measured as a rate per 1000 population is 1000.}

\item{reference_subgroup}{Identifies a reference subgroup with the value of
1.}

\item{sim}{The number of simulations to estimate 95\% confidence intervals}

\item{seed}{The random number generator (RNG) state for the 95\% confidence
interval simulation}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated MDRU value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The Mean Difference from a Reference Subgroup (MDR) is an absolute measure
of inequality that shows the mean difference between each population
subgroup and a reference subgroup. For the unweighted version (MDRU), all
subgroups are weighted equally.
}
\details{
The unweighted version (MDRU) is calculated as the average of absolute
differences between the subgroup estimates and the estimate for the
reference subgroup, divided by the number of subgroups. For more information
on this inequality measure see Schlotheuber, A., & Hosseinpoor, A. R. (2022)
below.

95\% confidence intervals are calculated using a methodology of simulated
estimates. The dataset is simulated a large number of times (e.g., 100)
and MDRU is calculated for each of the simulated samples. The 95\%
confidence intervals are based on the 2.5th and 97.5th percentiles of the
MDRU results.

\strong{Interpretation:} MDRU only has positive values, with larger values
indicating higher levels of inequality. MDRU is zero if there is no
inequality.

\strong{Type of summary measure:} Complex; absolute; non-weighted

\strong{Applicability:} Non-ordered; more than two subgroups
}
\examples{
# example code
data(NonorderedSample)
head(NonorderedSample)
with(NonorderedSample,
     mdru(est = estimate,
          se = se,
          scaleval = indicator_scale,
          reference_subgroup
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.
}
