// (c) The HDF Group
#ifndef H5FDpublic_H
#define H5FDpublic_H
#include "H5public.h"
#include "H5Fpublic.h"
#include "H5Ipublic.h"
#define H5FD_VFD_DEFAULT 0
#define H5_VFD_INVALID   ((H5FD_class_value_t)(-1))
#define H5_VFD_SEC2      ((H5FD_class_value_t)(0))
#define H5_VFD_CORE      ((H5FD_class_value_t)(1))
#define H5_VFD_LOG       ((H5FD_class_value_t)(2))
#define H5_VFD_FAMILY    ((H5FD_class_value_t)(3))
#define H5_VFD_MULTI     ((H5FD_class_value_t)(4))
#define H5_VFD_STDIO     ((H5FD_class_value_t)(5))
#define H5_VFD_SPLITTER  ((H5FD_class_value_t)(6))
#define H5_VFD_MPIO      ((H5FD_class_value_t)(7))
#define H5_VFD_DIRECT    ((H5FD_class_value_t)(8))
#define H5_VFD_MIRROR    ((H5FD_class_value_t)(9))
#define H5_VFD_HDFS      ((H5FD_class_value_t)(10))
#define H5_VFD_ROS3      ((H5FD_class_value_t)(11))
#define H5_VFD_SUBFILING ((H5FD_class_value_t)(12))
#define H5_VFD_IOC       ((H5FD_class_value_t)(13))
#define H5_VFD_ONION     ((H5FD_class_value_t)(14))
#define H5_VFD_RESERVED 256
#define H5_VFD_MAX 65535
#define H5FD_FEAT_AGGREGATE_METADATA 0x00000001
#define H5FD_FEAT_ACCUMULATE_METADATA_WRITE 0x00000002
#define H5FD_FEAT_ACCUMULATE_METADATA_READ  0x00000004
#define H5FD_FEAT_ACCUMULATE_METADATA                                                                        \
    (H5FD_FEAT_ACCUMULATE_METADATA_WRITE | H5FD_FEAT_ACCUMULATE_METADATA_READ)
#define H5FD_FEAT_DATA_SIEVE 0x00000008
#define H5FD_FEAT_AGGREGATE_SMALLDATA 0x00000010
#define H5FD_FEAT_IGNORE_DRVRINFO 0x00000020
#define H5FD_FEAT_DIRTY_DRVRINFO_LOAD 0x00000040
#define H5FD_FEAT_POSIX_COMPAT_HANDLE 0x00000080
#define H5FD_FEAT_HAS_MPI 0x00000100
#define H5FD_FEAT_ALLOCATE_EARLY 0x00000200
#define H5FD_FEAT_ALLOW_FILE_IMAGE 0x00000400
#define H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS 0x00000800
#define H5FD_FEAT_SUPPORTS_SWMR_IO 0x00001000
#define H5FD_FEAT_USE_ALLOC_SIZE 0x00002000
#define H5FD_FEAT_PAGED_AGGR 0x00004000
#define H5FD_FEAT_DEFAULT_VFD_COMPATIBLE 0x00008000
#define H5FD_FEAT_MEMMANAGE 0x00010000
#define H5FD_CTL_OPC_RESERVED 512
#define H5FD_CTL_OPC_EXPER_MIN                                                                               \
    H5FD_CTL_OPC_RESERVED
#define H5FD_CTL_OPC_EXPER_MAX                                                                               \
    (H5FD_CTL_OPC_RESERVED + 511)
#define H5FD_CTL_INVALID_OPCODE              0
#define H5FD_CTL_TEST_OPCODE                 1
#define H5FD_CTL_GET_MPI_COMMUNICATOR_OPCODE 2
#define H5FD_CTL_GET_MPI_INFO_OPCODE         9
#define H5FD_CTL_GET_MPI_RANK_OPCODE         3
#define H5FD_CTL_GET_MPI_SIZE_OPCODE         4
#define H5FD_CTL_MEM_ALLOC                   5
#define H5FD_CTL_MEM_FREE                    6
#define H5FD_CTL_MEM_COPY                    7
#define H5FD_CTL_GET_MPI_FILE_SYNC_OPCODE    8
#define H5FD_CTL_FAIL_IF_UNKNOWN_FLAG 0x0001
#define H5FD_CTL_ROUTE_TO_TERMINAL_VFD_FLAG 0x0002
typedef int H5FD_class_value_t;
typedef enum H5F_mem_t H5FD_mem_t;
//! <!-- [H5FD_file_image_op_t_snip] -->
typedef enum {
    H5FD_FILE_IMAGE_OP_NO_OP,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET,
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_CLOSE,
    H5FD_FILE_IMAGE_OP_FILE_OPEN,
    H5FD_FILE_IMAGE_OP_FILE_RESIZE,
    H5FD_FILE_IMAGE_OP_FILE_CLOSE
} H5FD_file_image_op_t;
//! <!-- [H5FD_file_image_op_t_snip] -->
//! <!-- [H5FD_file_image_callbacks_t_snip] -->
typedef struct {
    //! <!-- [image_malloc_snip] -->
    void *(*image_malloc)(size_t size, H5FD_file_image_op_t file_image_op, void *udata);
    //! <!-- [image_malloc_snip] -->
    //! <!-- [image_memcpy_snip] -->
    void *(*image_memcpy)(void *dest, const void *src, size_t size, H5FD_file_image_op_t file_image_op,
                          void *udata);
    //! <!-- [image_memcpy_snip] -->
    //! <!-- [image_realloc_snip] -->
    void *(*image_realloc)(void *ptr, size_t size, H5FD_file_image_op_t file_image_op, void *udata);
    //! <!-- [image_realloc_snip] -->
    //! <!-- [image_free_snip] -->
    herr_t (*image_free)(void *ptr, H5FD_file_image_op_t file_image_op, void *udata);
    //! <!-- [image_free_snip] -->
    //! <!-- [udata_copy_snip] -->
    void *(*udata_copy)(void *udata);
    //! <!-- [udata_copy_snip] -->
    //! <!-- [udata_free_snip] -->
    herr_t (*udata_free)(void *udata);
    //! <!-- [udata_free_snip] -->
    void *udata;
} H5FD_file_image_callbacks_t;
//! <!-- [H5FD_file_image_callbacks_t_snip] -->
//! <!-- [H5FD_ctl_memcpy_args_t_snip] -->
typedef struct H5FD_ctl_memcpy_args_t {
    void       *dstbuf;
    hsize_t     dst_off;
    const void *srcbuf;
    hsize_t     src_off;
    size_t      len;
} H5FD_ctl_memcpy_args_t;
//! <!-- [H5FD_ctl_memcpy_args_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5FDdriver_query(hid_t driver_id, unsigned long *flags);
#ifdef __cplusplus
}
#endif
#endif
