% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data60UK.R
\name{catalogueData60UK}
\alias{catalogueData60UK}
\title{Data source: Data60UK catalogue}
\source{
\url{http://nrfaapps.ceh.ac.uk/datauk60/data.html}
}
\usage{
catalogueData60UK(areaBox = NULL)
}
\arguments{
\item{areaBox}{bounding box, a list made of 4 elements: minimum longitude
(lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum
latitude (latMax)}
}
\value{
This function returns a data frame containing the following columns:
\describe{
  \item{\code{id}}{Station id number.}
  \item{\code{River}}{String describing the river's name.}
  \item{\code{Location}}{String describing the location.}
  \item{\code{gridReference}}{British National Grid Reference.}
  \item{\code{Latitude}}{}
  \item{\code{Longitude}}{}
}
}
\description{
This function interfaces the Data60UK database catalogue
listing 61 gauging stations.
}
\examples{
\dontrun{
  # Retrieve the whole catalogue
  Data60UK_catalogue_all <- catalogueData60UK()

  # Filter the catalogue based on a bounding box
  areaBox <- raster::extent(-4, -2, +52, +53)
  Data60UK_catalogue_bbox <- catalogueData60UK(areaBox)
}

}
\author{
Claudia Vitolo
}
