% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcbs.R
\name{dcbs.make.tree}
\alias{dcbs.make.tree}
\title{Growing a binary tree for DCBS algorithm}
\usage{
dcbs.make.tree(input, phi = 0.5, trim = NULL, height = NULL)
}
\arguments{
\item{input}{input data matrix, with each row representing the component time series or their transformation}

\item{phi, }{trim, height see \code{\link{dcbs.alg}}}
}
\value{
S3 \code{bin.tree} object, which contains the following fields:
   \item{tree}{a \link{list} object containing information about the nodes at which change-points are detected}
   \item{mat}{matrix concatenation of the nodes of \code{tree}}
   \item{ecp}{estimated change-points}
   \item{thr}{threshold used to construct the tree}
}
\description{
Grow a binary tree of a given height via Double CUSUM Binary Segmentation without thresholding
}
\keyword{internal}
