% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfectSample.R
\name{perfectSample}
\alias{perfectSample}
\title{Perfectly samples an MTD Markov chain}
\usage{
perfectSample(MTD, N = NULL)
}
\arguments{
\item{MTD}{An MTD object, see \code{\link[=MTDmodel]{MTDmodel()}} for properly generating a MTD object.}

\item{N}{The sample size. If \code{NULL} sample size will be set to 1000.}
}
\value{
Returns a sample from an MTD model (the first element is the most recent).
}
\description{
Samples an MTD Markov Chain from the stationary distribution.
}
\details{
This perfect sample algorithm requires that the MTD model has
an independent distribution (p0) with a positive weight (i.e., \code{MTD$lambdas["lam0"]>0} which
means \eqn{\lambda_0>0}).
}
\examples{
perfectSample(MTDmodel(Lambda=c(1,4), A = c(0,2)), N = 200 )
perfectSample(MTDmodel(Lambda=c(2,5), A = c(1,2,3)), N = 1000 )

}
