% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regWO_data_frame.R
\name{regWO.data.frame}
\alias{regWO.data.frame}
\title{Win odds regression using a data frame}
\usage{
\method{regWO}{data.frame}(x, AVAL, TRTP, COVAR, ref, alpha = 0.05, WOnull = 1, ...)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{COVAR}{a numeric covariate.}

\item{ref}{the reference treatment group.}

\item{alpha}{significance level. The default is 0.05.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval.
\itemize{
\item WO_beta adjusted win odds.
\item LCL lower confidence limit for adjusted WO.
\item UCL upper confidence limit for adjusted WO.
\item SE standard error of the adjusted win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item N total number of patients in the analysis.
\item beta adjusted win probability.
\item SE_beta standard error for the adjusted win probability.
\item SD_beta standard deviation for the adjusted win probability.
\item WP (non-adjusted) win probability.
\item SE_WP standard error of the non-adjusted win probability.
\item SD_WP standard deviation of the non-adjusted win probability.
\item WO non-adjusted win odds.
\item COVAR_MEAN_DIFF mean difference between two treatment groups of the numeric covariate.
\item COVAR_VAR sum of variances of two treatment groups of the numeric covariate.
\item COVAR_COV covariance between the response and the numeric covariate.
}
}
\description{
Win odds regression using a data frame
}
\examples{
# A baseline covariate that is highly correlated with the outcome
set.seed(2023)
dat <- COVID19
n <- nrow(dat)
dat$Severity <- ifelse(dat$GROUP > 4, rnorm(n, 0), rnorm(n, 100))
tapply(dat$Severity, dat$TRTP, mean)
regWO(x = dat, AVAL = "GROUP", TRTP = "TRTP", COVAR = "Severity", ref = "Placebo")
# Without adjustment
calcWO(x = dat, AVAL = "GROUP", TRTP = "TRTP", ref = "Placebo")
}
\references{
Gasparyan SB et al. (2021) "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2: 580-611. \url{doi:10.1177/0962280220942558}.
}
\seealso{
\code{\link[=regWO]{regWO()}}.
}
