% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbam.R
\name{fbam}
\alias{fbam}
\title{Fit the FBAM_MINI model using optimization}
\usage{
fbam(
  self = NULL,
  stimuli = NULL,
  allow_miss = 2,
  req_valid = NA,
  req_unique = 2,
  prep_data = TRUE,
  data = NULL,
  seed = sample.int(.Machine$integer.max, 1),
  ...
)
}
\arguments{
\item{self}{A numerical vector of N ideological self-placements. Any missing data must be coded as NA. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{stimuli}{An N × J matrix of numerical stimulus placements, where J is the number of stimuli. Any missing data must be coded as NA. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{allow_miss}{Integer specifying how many missing stimulus positions to be accepted for an individual still to be included in the analysis. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function. Defaults to 2.}

\item{req_valid}{Integer specifying how many valid observations to require for a respondent to be included in the analysis. The default is \code{req_valid = J - allow_miss}, but if specified, \code{req_valid} takes precedence. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{req_unique}{Integer specifying how may unique positions on the ideological scale each respondent is required to have used when placing the stimuli in order to be included in the analysis. The default is \code{req_unique = 2}. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{prep_data}{Logical: Should the data be prepared before fitting the model? (Or have the data been prepared in advance via the \code{prep_data} function? If so, set \code{prep_data = FALSE}.)}

\item{data}{List of data that have been prepared in advance via the \code{prep_data} function. Only applicable when \code{prep_data = TRUE}.}

\item{seed}{A positive integer specifying an optional seed for reproducibility. If this argument is not supplied, a random seed will be generated and the function will produce slightly different results on each run.}

\item{...}{Arguments passed to \code{rstan::optimizing}.}
}
\value{
A list produced by \code{rstan::optimizing}.
}
\description{
Fit a simplified Bayesian Aldrich-McKelvey model with fixed hyperparameters using optimization via \code{rstan}.
}
\examples{
\donttest{
# Loading and re-coding ANES 2012 data:
data(LC2012)
dat <- LC2012

self <- dat[, 2]
stimuli <- dat[, -c(1:2)]

# Fitting the FBAM_MINI model:
fit_fbam_mini <- fbam(self, stimuli)

# Obtaining point estimates for the latent stimulus positions:
theta_est <- get_est(fit_fbam_mini, par = "theta")
}
}
