% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels.R
\name{get_levels}
\alias{get_levels}
\alias{get_outcome_levels}
\title{Extract factor levels from a data frame}
\usage{
get_levels(data)

get_outcome_levels(y)
}
\arguments{
\item{data}{A data.frame to extract levels from.}

\item{y}{The outcome. This can be:
\itemize{
\item A factor vector
\item A numeric vector
\item A 1D numeric array
\item A numeric matrix with column names
\item A 2D numeric array with column names
\item A data frame with numeric or factor columns
}}
}
\value{
A named list with as many elements as there are factor columns in \code{data}
or \code{y}. The names are the names of the factor columns, and the values
are character vectors of the levels.

If there are no factor columns, \code{NULL} is returned.
}
\description{
\code{get_levels()} extracts the levels from any factor columns in \code{data}. It is
mainly useful for extracting the original factor levels from the predictors
in the training set. \code{get_outcome_levels()} is a small wrapper around
\code{get_levels()} for extracting levels from a factor outcome
that first calls \code{\link[=standardize]{standardize()}} on \code{y}.
}
\examples{

# Factor columns are returned with their levels
get_levels(iris)

# No factor columns
get_levels(mtcars)

# standardize() is first run on `y`
# which converts the input to a data frame
# with an automatically named column, `".outcome"`
get_outcome_levels(y = factor(letters[1:5]))

}
\seealso{
\code{\link[stats:.getXlevels]{stats::.getXlevels()}}
}
