% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_hist.R
\name{hanr_histogram}
\alias{hanr_histogram}
\title{Anomaly detector using histograms}
\usage{
hanr_histogram(density_threshold = 0.05)
}
\arguments{
\item{density_threshold}{Numeric between 0 and 1. Minimum bin density to avoid being
considered an anomaly (default 0.05).}
}
\value{
\code{hanr_histogram} object
}
\description{
Flags observations that fall into low-density histogram bins or outside the
observed bin range.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure histogram-based detector
model <- hanr_histogram()

# Fit the model (no-op)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
