% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.Classes.R
\docType{class}
\name{hbr-class}
\alias{hbr}
\alias{hbr-class}
\title{An S4 class storing results from haplotype-block reconstruction}
\description{
An S4 class containg input parameters and results for reconstructed 
haplotype-blocks
}
\details{
An S4 class containing a SNP_time_series data object, the haplotype-blocks were
constructed on, parameters that were used for haplotype-block reconstruction and results
of haplotype block reconstruction. An hbr object can only be created with 
\code{\link{reconstruct_hb}}.
}
\section{Slots}{

\describe{
\item{\code{dat}}{A SNP_time_series object containg the time series data and threshold used for 
marker filtering (refer to \code{SNP_time_series} for more details)}

\item{\code{chromosome}}{The chromosome for which haplotype-blocks were calculated.}

\item{\code{min.cl.size}}{Numeric specifying the minimum number of correlated markers in a 
window for haplotype-block reconstruction}

\item{\code{min.cl.cor}}{Numeric specifying the correlation between marker SNPs required 
using average linkage clustering for markers to be assembled in one cluster}

\item{\code{min.inter}}{Numeric specifying the minimum number of markers in two clusters 
of overlapping windows required to be identical for cluster elongation across windows 
to build haplotype-blocks}

\item{\code{single.win}}{Boolean specifying that are supported by only a cluster in one window are 
also included in the markers of reconstructed blocks. If FALSE only hbrs are returned that span
at least two windows and only markers being present in the intersection between overlapping
windows are included.}

\item{\code{transf}}{Boolean indicating if time series data was sqrt transformed
prior to clustering.}

\item{\code{scaleSNP}}{Boolean indicating if time series data was scaled (mean=0, var=1)
for each SNP prior to clustering.}

\item{\code{pos.cor}}{Boolean indicating if negative correletions between time series between
two SNPs were set to zero prior to clustering.}

\item{\code{cl.chr}}{A list containing results from clustering of low frequency markers in the 
experimental starting population for each window. Each list element contains the results 
for a window.If clusters for the respective window were identified the respective list
numeric vectors with the marker positions for each cluster. If no clusters were identified 
the list is empty. The clusters identified for overlapping windows are the basis for 
cluster elongation to haplotype-blocks as present in \code{cl.long.m}.}

\item{\code{cl.long.m}}{A list containing the results of haplotype-bock reconstruction. Each 
list element corresponds to a reconstructed #' haplotype-block and contains a numeric 
vector with all the SNP positions. The minor allele in the experimnental starting
population at those positions represent marker alleles for the respective hapltotype-block. 
Chromosome-wide haplotype-blocks can be visualized with \code{plot}.}
}}
\author{
Susanne U. Franssen
}
\references{
Franssen, Barton & Schloetterer 2016, \href{http://mbe.oxfordjournals.org/content/early/2016/10/03/molbev.msw210.abstract}{Reconstruction of haplotype-blocks
selected during experimental evolution}, \href{http://mbe.oxfordjournals.org/}{MBE}
}
\seealso{
\code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

