% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModeling_modelfunctions.R
\name{drop_burnin}
\alias{drop_burnin}
\title{Drop Burn-In}
\usage{
drop_burnin(model, burn_in)
}
\arguments{
\item{model}{A list of MCMC draws from a model fit with \code{\link[=fit_model]{fit_model()}}.}

\item{burn_in}{An integer number of starting iterations to drop from each MCMC chain.}
}
\value{
A list of data frames of MCMC draws with burn-in dropped.
}
\description{
\code{drop_burnin()} removes the burn-in from the Markov Chain Monte Carlo (MCMC) draws.
}
\examples{
model <- drop_burnin(model = example_model_1chain, burn_in = 25)
plot_trace(variable = "mu[1,2]", model = example_model_1chain)

}
