% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotLetter}
\alias{plotLetter}
\title{plotLetter}
\usage{
plotLetter(
  letterList,
  whichLetter,
  dims,
  showPaths = TRUE,
  showCentroid = TRUE,
  showSlope = TRUE
)
}
\arguments{
\item{letterList}{Letter list from processHandwriting function}

\item{whichLetter}{Single value in 1:length(letterList) denoting which letter to plot.}

\item{dims}{Dimensions of the original document}

\item{showPaths}{Whether the calculated paths on the letter should be shown with numbers.}

\item{showCentroid}{Whether the centroid should be shown}

\item{showSlope}{whether the slope should be shown}
}
\value{
Plot of single letter.
}
\description{
This function returns a plot of a single letter extracted from a document. 
It uses the letterList parameter from the processHandwriting function and accepts a single value as whichLetter. 
Dims requires the dimensions of the entire document, since this isn't contained in processHandwriting.
}
\examples{
twoSent_document = list()
twoSent_document$image = twoSent
twoSent_document$thin = thinImage(twoSent_document$image)
twoSent_processList = processHandwriting(twoSent_document$thin, dim(twoSent_document$image))

dims = dim(twoSent_document$image)
plotLetter(twoSent_processList$letterList, 1, dims)
plotLetter(twoSent_processList$letterList, 4, dims)
}
