% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{importance}
\alias{importance}
\title{Importance of variables based on partial chi-square statistic}
\usage{
importance(model)
}
\arguments{
\item{model}{an assess class object or models with lm or glm class.}
}
\value{
a data.frame object with partial X^2 summary statistics.
}
\description{
Calculates partial chi-square (Wald chi-square for individual
coefficients) from assess class objects. The
importance is the partial chi-square minus its degrees
of freedom based on the regression coefficients (Harrell, 2015).
A higher chi-square indicates a larger effect by the predictors.
Therefore, the rank of the chi-square can indicate which predictors
can contribute more in explaining the variation in the outcome variable.
}
\examples{
# OLS regression
importance(assess(mpg ~ hp + wt + cyl, data=mtcars, regression= "ols")$model)

# logistic regression
importance(assess(vs~mpg+wt+hp, data=mtcars, regression= "logistic")$model)

}
\references{
Harrell, F. E., Jr. (2016). Regression Modeling Strategies. Springer
International Publishing. ISBN: 978-3-319-19424-0.
}
