% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipw_shift.R
\name{ipw_shift}
\alias{ipw_shift}
\title{IPW Estimates of the Causal Effects of Stochatic Shift Interventions}
\usage{
ipw_shift(
  W,
  A,
  Y,
  delta,
  n_bins = make_bins(A, "hist"),
  cv_folds = 10L,
  lambda_seq,
  ...,
  bin_type = c("equal_range", "equal_mass"),
  trim_density = FALSE,
  undersmooth_type = c("dcar", "plateau", "gcv", "all"),
  bootstrap = FALSE,
  n_boot = 1000L
)
}
\arguments{
\item{W}{A \code{matrix}, \code{data.frame}, or similar containing a set of
baseline covariates.}

\item{A}{A \code{numeric} vector corresponding to a exposure variable. The
parameter of interest is defined as a location shift of this quantity.}

\item{Y}{A \code{numeric} vector of the observed outcomes.}

\item{delta}{A \code{numeric} value indicating the shift in the exposure to
be used in defining the target parameter. This is defined with respect to
the scale of the exposure (A).}

\item{n_bins}{A \code{numeric}, scalar or vector, indicating the number of
bins into which the support of A is to be partitioned for constructing
conditional density estimates.}

\item{cv_folds}{A \code{numeric} giving the number of folds to be used for
cross-validation. Note that this form of sample splitting is used for the
selection of tuning parameters by empirical risk minimization, not for the
estimation of nuisance parameters (i.e., to relax regularity conditions).}

\item{lambda_seq}{A \code{numeric} sequence of the regularization parameter
(L1 norm of HAL coefficients) to be used in fitting HAL models.}

\item{...}{Additional arguments for model fitting to be passed directly to
\code{\link[haldensify]{haldensify}}.}

\item{bin_type}{A \code{character} indicating the strategy to be used in
creating bins along the observed support of \code{A}. For bins of equal
range, use \code{"equal_range"}; to ensure each bin has the same number of
observations, use instead \code{"equal_mass"}. For more information, see
documentation of \code{grid_type} in \code{\link[haldensify]{haldensify}}.}

\item{trim_density}{A \code{logical} indicating whether estimates of the
conditional density should be trimmed. Refer to the \code{trim} argument of
the \code{predict} method of \code{haldensify} for details. The default is
\code{FALSE} since propensity score truncation can lead to estimation bias.}

\item{undersmooth_type}{A \code{character} indicating the selection strategy
to be used in identifying an efficent IPW estimator. The choices include
\code{"gcv"} for global cross-validation, \code{"dcar"} for solving the
IPW representation of the EIF through, and \code{"plateau"} for an approach
that balances changes in the parameter estimate and its mean squared error,
based on Lepski's method. The option \code{"all"} produces results based on
all three selection strategies, sharing redundant computation between each.}

\item{bootstrap}{A \code{logical} indicating whether the estimator variance
should be approximated using the nonparametric bootstrap. The default is
\code{FALSE}, in which case the empirical variances of the IPW estimating
function and the EIF are used for for estimator selection and for variance
estimation, respectively. When set to \code{TRUE}, the bootstrap variance
is used for both of these purposes instead. Note that the bootstrap is very
computationally intensive and scales relatively poorly.}

\item{n_boot}{A \code{numeric} giving the number of bootstrap re-samples to
be used in computing the mean squared error as part of the plateau selector
criterion. Ignored when \code{undersmooth_type} is not \code{"plateau"}.}
}
\description{
IPW Estimates of the Causal Effects of Stochatic Shift Interventions
}
\examples{
# simulate data
n_obs <- 50
W1 <- rbinom(n_obs, 1, 0.6)
W2 <- rbinom(n_obs, 1, 0.2)
A <- rnorm(n_obs, (2 * W1 - W2 - W1 * W2), 2)
Y <- rbinom(n_obs, 1, plogis(3 * A + W1 + W2 - W1 * W2))

# fit the IPW estimator
est_ipw_shift <- ipw_shift(
  W = cbind(W1, W2), A = A, Y = Y,
  delta = 0.5, n_bins = 3L, cv_folds = 2L,
  lambda_seq = exp(seq(-1, -10, length = 100L)),
  # arguments passed to hal9001::fit_hal()
  max_degree = 1,
  # ...continue arguments for IPW
  undersmooth_type = "gcv"
)
}
