% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readutils.R
\name{readbinarycf}
\alias{readbinarycf}
\title{read correlation function from binary files}
\usage{
readbinarycf(files, Time, obs = 5, Nop = 1, symmetrise = TRUE,
  endian = "little", op = "aver", excludelist = c(""), sym = TRUE,
  path = "", hdf5format = FALSE, hdf5name, hdf5index = c(1, 2))
}
\arguments{
\item{files}{list of filenames to be read. Can be created using
\code{getorderedfilelist}. The filelist is assumed to be order according to
ascending gauge fields.}

\item{Time}{time extent of correlation functions.}

\item{obs}{each file may contain many correlation functions. With 'obs'
one choses which observable to read in. To be precise, in each file the
reading will start at point Time\emph{obs}sizeof(complex\code{<double>}) and read
Nop\emph{Time}sizeof(complex\code{<double>}).}

\item{Nop}{number of replicas for the correlator to read in.}

\item{symmetrise}{symmetrise the correlation function or not}

\item{endian}{the endianess of the binary file.}

\item{op}{the N replicas can be either averaged (\code{op="aver"}) or summed
(\code{op="sum"}).}

\item{excludelist}{files to exclude from reading.}

\item{sym}{if \code{TRUE} average C(+t) and C(-t), otherwise C(+t) and
-C(-t).}

\item{path}{path to be prepended to every filename.}

\item{hdf5format}{if \code{TRUE}, try to read from an hdf5 file.}

\item{hdf5name}{Name of the data set as a string.}

\item{hdf5index}{The data might be an array of size n x Time. \code{hdf5index}
is used to convert two columns of the data to a complex valued vector using
the first and second index for real and imaginary part, respectively. If
\code{hdf5index} has length smaller than 2 the first index is reused.}
}
\value{
returns a list with two arrays \code{cf} and \code{icf} with real
and imaginary parts of the correlator, and integers \code{Time},
\code{nrStypes=1} and \code{nrObs=1}. Both of the arrays have dimension
\code{c(N, (Time/2+1))}, where \code{N} is the number of measurements
(gauges).  \code{Time} is the time extent, \code{nrStypes} the number of
smearing levels and \code{nrObs} the number of operators, both of which are
currently fixed to 1.
}
\description{
Reads a correlation function from binary files, including hdf5 formatted
files.
}
\details{
It is assumend that each file contains at least \code{(obs+N)*Time} complex
doubles, where \code{Time} is the time extent, \code{obs} is the number of the
observable to read in and \code{Nop} the number of replicas for this
observable. It is assumed that complex is the fastest running index, next
time and then obs. The filelist is assumed to be ordered according to the
gauge configuration MC history.
}
\examples{

X <- readbinarycf(path=paste0(system.file(package="hadron"), "/extdata/"),
                  files="C2_bin.dat", Time=64, obs=0)
X
X$cf

}
\seealso{
\code{\link{readcmidatafiles}}, \code{\link{readbinarydisc}},
\code{\link{readcmidisc}}, \code{\link{readcmicor}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{file}
