% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchyWide.R
\name{hierarchyWide}
\alias{hierarchyWide}
\title{hierarchyWide}
\usage{
hierarchyWide(ee, supv, printTree = TRUE)
}
\arguments{
\item{ee}{A list of values representing employees (e.g. employee IDs).}

\item{supv}{A list of values representing the supervisors of the employees. These values should be
of the same type as the employee values.}

\item{printTree}{Logical indicator to print the calculated data tree to the console.}
}
\value{
data frame
}
\description{
This function takes employee and supervisor
identifiers (name, ID, etc.) and returns a wide data frame consisting of
a single row per employee and their respective reporting hierarchy in a wide format.

The resulting format is very useful for subsequent aggregation of employee data
for a particular leadership tree.
}
\examples{
ee = c("Dale","Bob","Julie","Susan")
supv = c("Julie","Julie","Susan","George")
hierarchyWide(ee,supv)
}
