% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneLevelNMF.R
\name{oneLevelNMF}
\alias{oneLevelNMF}
\title{Perform Non-Negative Matrix factorization}
\usage{
oneLevelNMF(X, rank, initData = NULL, method = "PGNMF", nruns = 10,
  checkDivergence = TRUE)
}
\arguments{
\item{X}{input matrix}

\item{rank}{number of NMF components to be found}

\item{initData}{either of the NMF factor matrices, with initial values}

\item{method}{name of the NMF method to be used. "PGNMF" (default) and "HALSacc" 
are available by default. Any method from the NMF package can also be specified}

\item{nruns}{number of NMF runs. It is recommended to run the NMF analyses multiple
times when random seeding is used, to avoid a suboptimal solution}

\item{checkDivergence}{Boolean indicating whether divergence checking should be performed}
}
\value{
Scaled NMF model (in accordance with the NMF package definition)
}
\description{
Perform Non-Negative Matrix factorization
}
\author{
Nicolas Sauwen
}
