% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automlModelParam.R
\name{automlModelParam}
\alias{automlModelParam}
\title{AutoML Models' Parameters Summary}
\usage{
automlModelParam(model)
}
\arguments{
\item{model}{a h2o AutoML object}
}
\value{
a dataframe of models' parameters
}
\description{
Extracts models' parameters from AutoML grid
}
\examples{
\donttest{
if(requireNamespace("h2o")) {
  library(h2o)
  h2o.init(ignore_config = TRUE)
  prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
  prostate <- h2o.importFile(path = prostate_path, header = TRUE)
  y <- "CAPSULE"
  prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
  aml <- h2o.automl(y = y,
                    training_frame = prostate,
                    include_algos = "GLM",
                    max_models = 1,
                    max_runtime_secs = 60)

  # extract the model parameters
  model.param <- automlModelParam(aml@leader)
}
}
}
\author{
E. F. Haghish
}
