% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.anyFactor}
\alias{h2o.anyFactor}
\title{Check Frame columns for factors}
\usage{
h2o.anyFactor(x)
}
\arguments{
\item{x}{An \code{Frame} object.}
}
\value{
Returns a logical value indicating whether any of the columns in \code{x} are factors.
}
\description{
Determines if any column of an H2O Frame object contains categorical data.
}
\examples{
\donttest{
library(h2o)
h2o.init()
irisPath <- system.file("extdata", "iris_wheader.csv", package="h2o")
iris.hex <- h2o.importFile(path = irisPath)
h2o.anyFactor(iris.hex)
}
}

