% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.trunc}
\alias{h2o.trunc}
\title{Truncate values in x toward 0}
\usage{
h2o.trunc(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\description{
trunc takes a single numeric argument x and returns a numeric vector containing the integers
formed by truncating the values in x toward 0.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

frame <- h2o.createFrame(rows = 6, cols = 2,
                         categorical_fraction = 0.0, 
                         missing_fraction = 0.7, 
                         seed = 123)
h2o.trunc(frame["C1"])
}
}
\seealso{
\code{\link[base]{Round}} for the base R implementation, \code{trunc()}.
}
