% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{H2OModel-class}
\alias{H2OModel-class}
\alias{H2OModel}
\alias{show,H2OModel-method}
\alias{H2OUnknownModel-class}
\alias{H2OBinomialModel-class}
\alias{H2OMultinomialModel-class}
\alias{H2OOrdinalModel-class}
\alias{H2ORegressionModel-class}
\alias{H2OAutoEncoderModel-class}
\alias{H2ODimReductionModel-class}
\alias{H2OWordEmbeddingModel-class}
\title{The H2OModel object.}
\usage{
\S4method{show}{H2OModel}(object)
}
\arguments{
\item{object}{an \code{H2OModel} object.}
}
\description{
This virtual class represents a model built by H2O.
}
\details{
This object has slots for the key, which is a character string that points to the model key existing in the H2O cloud,
the data used to build the model (an object of class H2OFrame).
}
\section{Slots}{

\describe{
\item{\code{model_id}}{A \code{character} string specifying the key for the model fit in the H2O cloud's key-value store.}

\item{\code{algorithm}}{A \code{character} string specifying the algorithm that were used to fit the model.}

\item{\code{parameters}}{A \code{list} containing the parameter settings that were used to fit the model that differ from the defaults.}

\item{\code{allparameters}}{A \code{list} containg all parameters used to fit the model.}

\item{\code{have_pojo}}{A \code{logical} indicating whether export to POJO is supported}

\item{\code{have_mojo}}{A \code{logical} indicating whether export to MOJO is supported}

\item{\code{model}}{A \code{list} containing the characteristics of the model returned by the algorithm.}
}}

