% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.nrow}
\alias{h2o.nrow}
\alias{ncol,H2OFrame-method}
\alias{nrow,H2OFrame-method}
\title{The Number of Rows/Columns of an H2O Dataset}
\usage{
\S4method{nrow}{H2OFrame}(x)

\S4method{ncol}{H2OFrame}(x)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}
}
\description{
Returns a count of the number of rows or columns in an \code{\linkS4class{H2OFrame}} object.




}
\examples{
library(h2o)
localH2O <- h2o.init()
irisPath <- system.file("extdata", "iris.csv", package="h2o")
iris.hex <- h2o.uploadFile(localH2O, path = irisPath)
nrow(iris.hex)
ncol(iris.hex)
}
\seealso{
\code{\link{dim}} for all the dimensions. \code{\link[base]{nrow}} for the default R method.
}

