% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.metric}
\alias{h2o.F0point5}
\alias{h2o.F1}
\alias{h2o.F2}
\alias{h2o.accuracy}
\alias{h2o.error}
\alias{h2o.fallout}
\alias{h2o.fnr}
\alias{h2o.fpr}
\alias{h2o.maxPerClassError}
\alias{h2o.mcc}
\alias{h2o.metric}
\alias{h2o.missrate}
\alias{h2o.precision}
\alias{h2o.recall}
\alias{h2o.sensitivity}
\alias{h2o.specificity}
\alias{h2o.tnr}
\alias{h2o.tpr}
\title{H2O Model Metric Accessor Functions}
\usage{
h2o.metric(object, thresholds, metric)

h2o.F0point5(object, thresholds)

h2o.F1(object, thresholds)

h2o.F2(object, thresholds)

h2o.accuracy(object, thresholds)

h2o.error(object, thresholds)

h2o.maxPerClassError(object, thresholds)

h2o.mcc(object, thresholds)

h2o.precision(object, thresholds)

h2o.tpr(object, thresholds)

h2o.fpr(object, thresholds)

h2o.fnr(object, thresholds)

h2o.tnr(object, thresholds)

h2o.recall(object, thresholds)

h2o.sensitivity(object, thresholds)

h2o.fallout(object, thresholds)

h2o.missrate(object, thresholds)

h2o.specificity(object, thresholds)
}
\arguments{
\item{object}{An \linkS4class{H2OModelMetrics} object of the correct type.}

\item{thresholds}{A value or a list of values between 0.0 and 1.0.}

\item{metric}{A specified paramter to retrieve.}
}
\value{
Returns either a single value, or a list of values.
}
\description{
A series of functions that retrieve model metric details.
}
\details{
Many of these functions have an optional thresholds parameter. Currently
only increments of 0.1 are allowed. If not specified, the functions will
return all possible values. Otherwise, the function will return the value for
the indicated threshold.

Currently, the these functions are only supported by
\linkS4class{H2OBinomialMetrics} objects.
}
\examples{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
hex <- h2o.uploadFile(prosPath)

hex[,2] <- as.factor(hex[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = hex, distribution = "bernoulli")
perf <- h2o.performance(model, hex)
h2o.F1(perf)
}
\seealso{
\code{\link{h2o.auc}} for AUC, \code{\link{h2o.giniCoef}} for the
         GINI coefficient, and \code{\link{h2o.mse}} for MSE. See
         \code{\link{h2o.performance}} for creating H2OModelMetrics objects.
}

