% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{loadSuspicious}
\alias{loadSuspicious}
\title{Load suspicious GWAS results into a single data.frame}
\usage{
loadSuspicious(path, focus, ..., extraColumns = c(), signAdj = NULL)
}
\arguments{
\item{path}{vector of paths to result files created by \link{GWAS}}

\item{focus}{parameter name on which to calculate a Z score and p-value}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{extraColumns}{character vector of additional columns to load}

\item{signAdj}{name of column. Value of focus parameter is multiplied by the sign of the named column}
}
\description{
\lifecycle{maturing}
These rows are excluded by \link{loadResults}.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
loadSuspicious(file.path(tdir,"out.log"), "snp2anxiety")
}
\seealso{
Other reporting: 
\code{\link{isSuspicious}()},
\code{\link{loadResults}()},
\code{\link{plot.gwsemResult}()}
}
\concept{reporting}
