% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{plot.gwsemResult}
\alias{plot.gwsemResult}
\title{Creates a Manhattan plot}
\usage{
\method{plot}{gwsemResult}(x, y, ...)
}
\arguments{
\item{x}{the result of \link{loadResults}}

\item{y}{an extra argument that should not be used}

\item{...}{arguments forwarded to \link[qqman]{manhattan}}
}
\value{
A Manhattan plot.
}
\description{
Uses the qqman package to create a Manhattan plot.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
got <- loadResults(file.path(tdir,"out.log"), "snp2anxiety")
plot(got)
}
