% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisI.R
\name{LogisI}
\alias{LogisI}
\title{Logistic Type I Distribution}
\usage{
LogisI()
}
\value{
An object of class "family" for logistic type I distribution.
}
\description{
Family objects for logistic type I distribution provide a convenient way to specify the details of the models used by functions such as \code{elliptical}.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitLI <- elliptical(y ~ x1+x2+x3, family = LogisI()
,data=luz)
family(elliptical.fitLI)
}
\references{
Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{family.elliptical}}, \code{\link{elliptical}}, \code{\link{gwer}}
}
\keyword{distributions}
\keyword{elliptical}
