% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_studies.R
\name{get_studies_by_full_pvalue_set}
\alias{get_studies_by_full_pvalue_set}
\title{Get GWAS Catalog studies by full summary statistics criterion}
\usage{
get_studies_by_full_pvalue_set(
  full_pvalue_set = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{full_pvalue_set}{A \code{logical} (scalar!) indicating to retrieve
studies with full summary statistics (\code{TRUE}) or studies without it
(\code{FALSE}).}

\item{verbose}{Whether the function should be verbose about the different
queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{studies} object.
}
\description{
Gets studies that either have full summary statistics or studies that do not
have it.
}
\keyword{internal}
