% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm-marginals.R
\name{glcm_statistics}
\alias{glcm_statistics}
\alias{glcm_mean}
\alias{mu_x.matrix}
\alias{mu_y.matrix}
\alias{glcm_variance}
\title{Statistics of GLCM}
\usage{
glcm_mean(glcm)

mu_x.matrix(glcm)

mu_y.matrix(glcm)

glcm_variance(glcm)
}
\arguments{
\item{glcm}{gray level co-occurrence matrix}
}
\value{
int or double (glcm_mean: single value, mean of symmetric glcm)

int or double (mu_x: weighted mean of reference node values)

int or double (mu_y: weighted mean of neighbor node values)

int or double (glcm_variance: glcm variance)
}
\description{
Functions for the calculation of summary statistics upon the GLCM matrix.

glcm_mean: GLCM mean of a symmetric GLCM matrix.
The GLCM Mean is not simply the average of all the original node values
in the network/graph. It is expressed in terms of the GLCM. The node
value is weighted not by its frequency of occurrence by itself (as in a
"regular" or familiar mean but by its frequency of its occurrence in
combination with a certain neighbour node value; see
\url{https://prism.ucalgary.ca/server/api/core/bitstreams/8f9de234-cc94-401d-b701-f08ceee6cfdf/content}

glcm_variance: The variance of the GLCM values
}
