% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_unhide}
\alias{cols_unhide}
\title{Unhide one or more columns}
\usage{
cols_unhide(data, columns)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The column names to unhide from the output display table.
Values provided that do not correspond to column names will be disregarded.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{cols_unhide()} function allows us to take one or more hidden columns
(usually made so via the \code{\link[=cols_hide]{cols_hide()}} function) and make them visible
in the final output table. This may be important in cases where the user
obtains a \code{gt_tbl} object with hidden columns and there is motivation to
reveal one or more of those.
}
\details{
The hiding and unhiding of columns is internally a rendering directive, so,
all columns that are 'hidden' are still accessible and useful in any
expression provided to a \code{rows} argument. The \code{cols_unhide()} function
quietly changes the visible state of a column (much like the \code{\link[=cols_hide]{cols_hide()}}
function) and doesn't yield warnings or messages when changing the state of
already-visible columns.
}
\section{Figures}{

\if{html}{\figure{man_cols_unhide_1.png}{options: width=100\%}}

\if{html}{\figure{man_cols_unhide_2.png}{options: width=100\%}}
}

\section{Function ID}{

4-8
}

\examples{
# Use `countrypops` to create a gt table;
# Hide the columns `country_code_2` and
# `country_code_3`
tab_1 <-
  countrypops \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_hide(
    columns = c(
      country_code_2,
      country_code_3
     )
  )

# If the `tab_1` object is provided without
# the code or source data to regenerate it, and,
# the user wants to reveal otherwise hidden
# columns then the `cols_unhide()` function
# becomes useful
tab_2 <-
  tab_1 \%>\%
  cols_unhide(columns = country_code_2)

}
\seealso{
\code{\link[=cols_hide]{cols_hide()}} to perform the inverse operation.

Other Modify Columns: 
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_width}()}
}
\concept{Modify Columns}
