% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{extract_body}
\alias{extract_body}
\title{Extract the table body from a \strong{gt} object}
\usage{
extract_body(
  data,
  build_stage = NULL,
  output = c("html", "latex", "rtf", "word")
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{build_stage}{\emph{The build stage of the formatted R data frame}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

When a \strong{gt} undergoes rendering, the body of the table proceeds through
several build stages. Providing a single stage name will yield a data frame
that has been extracted after completed that stage. Here are the build
stages in order: (1) \code{"init"}, (2) \code{"fmt_applied"}, (3) \code{"sub_applied"},
(4) \code{"unfmt_included"}, (5) \code{"cols_merged"}, (6) \code{"body_reassembled"}, (7)
\code{"text_transformed"}, and (8) \code{"footnotes_attached"}. If not supplying a
value for \code{build_stage} then the entire build for the table body (i.e., up
to and including the \code{"footnotes_attached"} stage) will be performed before
returning the data frame.}

\item{output}{\emph{Output format}

\verb{singl-kw:[html|latex|rtf|word]} // \emph{default:} \code{"html"}

The output format of the resulting data frame. This can either be
\code{"html"} (the default), \code{"latex"}, \code{"rtf"}, or \code{"word"}.}
}
\value{
A data frame or tibble object containing the table body.
}
\description{
We can extract the body of a \strong{gt} table, even at various stages of its
rendering, from a \code{gt_tbl} object using the \code{extract_body()} function. By
default, the data frame returned will have gone through all of the build
stages but we can intercept the table body after a certain build stage.
Here are the eight different build stages and some notes about each:
\enumerate{
\item \code{"init"}: the body table is initialized here, entirely with \code{NA} values.
It's important to note that all columns of the are of the \code{character} type in
this first stage. And all columns remain in the same order as the input data
table.
\item \code{"fmt_applied"}: Any cell values that have had formatting applied to them
are migrated to the body table. All other cells remain as \code{NA} values.
Depending on the \code{output} type, the formatting may also be different.
\item \code{"sub_applied"}: Any cell values that have had substitution functions
applied to them (whether or not they were previously formatted) are migrated
to the body table or modified in place (if formatted). All cells that had
neither been formatted nor undergone substitution remain as \code{NA} values.
\item \code{"unfmt_included"}: All cells that either didn't have any formatting or
any substitution operations applied are migrated to the body table. \code{NA}
values now become the string \code{"NA"}, so, there aren't any true missing values
in this body table.
\item \code{"cols_merged"}: The result of column-merging operations (though
\code{\link[=cols_merge]{cols_merge()}} and related functions) is materialized here. Columns that were
asked to be hidden will be present here (i.e., hiding columns doesn't remove
them from the body table).
\item \code{"body_reassembled"}: Though columns do not move positions rows can move
to different positions, and this is usually due to migration to different row
groups. At this stage, rows will be in the finalized order that is seen in
the associated display table.
\item \code{"text_transformed"}: Various \verb{text_*()} functions in \strong{gt} can operate
on body cells (now fully formatted at this stage) and return transformed
character values. After this stage, the effects of those functions are
apparent.
\item \code{"footnotes_attached"}: Footnote marks are attached to body cell values
(either on the left or right of the content). This stage performs said
attachment.
}
}
\section{Function ID}{

13-6
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{as_word}()},
\code{\link{extract_cells}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
