% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_from_t}
\alias{gsw_entropy_from_t}
\title{Specific Entropy i.t.o. Absolute Salinity, Temperature, and Pressure}
\usage{
gsw_entropy_from_t(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
specific entropy [ J/(kg*K) ]
}
\description{
Calculates specific entropy in terms of Absolute Salinity, in-situ
temperature and pressure.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
e <- gsw_entropy_from_t(SA, t, p)
stopifnot(all.equal(e/1e2, c(4.003894252787245, 3.954381784340642, 3.198664981986740,
                             1.467908815899072, 0.986473408657975, 0.627915087346090)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_from_t.html}
}
\seealso{
Other things related to entropy: 
\code{\link{gsw_CT_from_entropy}()},
\code{\link{gsw_entropy_first_derivatives}()},
\code{\link{gsw_entropy_from_pt}()},
\code{\link{gsw_entropy_ice}()},
\code{\link{gsw_pt_from_entropy}()}
}
\concept{things related to entropy}
