% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_freezing_poly}
\alias{gsw_CT_freezing_poly}
\title{Conservative Temperature Freezing Point (Polynomial version)}
\usage{
gsw_CT_freezing_poly(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{saturation fraction of dissolved air in seawater}
}
\value{
Conservative Temperature at freezing of seawater [ degC ].
}
\description{
Conservative Temperature Freezing Point (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <-  c(     10,      50,     125,     250,     600,    1000)
saturation_fraction <- 1
CT_freezing <- gsw_CT_freezing(SA, p, saturation_fraction)
expect_equal(CT_freezing, c(-1.899683776424096, -1.940791867869104, -2.006240664432488,
                            -2.092357761318778, -2.359300831770506, -2.677162675412748))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_freezing_poly.html}
}
