% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sigma0}
\alias{gsw_sigma0}
\title{Potential density anomaly referenced to 0 dbar}
\usage{
gsw_sigma0(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}
}
\value{
potential density anomaly [ kg/m^3 ]
}
\description{
This uses the 48-term density equation, and returns
potential density referenced to a pressure of 0 dbar,
minus 1000 kg/m^3.
}
\examples{
gsw_sigma0(34.7118, 28.8099) # 21.798411276610750
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html}
}
\seealso{
Use \code{\link{gsw_sigma1}} for 1000 dbar pressure, \code{\link{gsw_sigma2}} for 2000 dbar, \code{\link{gsw_sigma3}} for 3000 dbar, or \code{\link{gsw_sigma4}} for 4000 dbar.
}

