% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{vcov.gsl_nls}
\alias{vcov.gsl_nls}
\title{Calculate variance-covariance matrix}
\usage{
\method{vcov}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
A matrix containing the estimated covariances between the parameter estimates similar
to \code{\link[stats]{vcov}} with row and column names corresponding to the parameter names given by \code{\link{coef.gsl_nls}}.
}
\description{
Returns the estimated variance-covariance matrix of the model parameters
from a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n, 
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

vcov(obj)
}
\seealso{
\code{\link[stats]{vcov}}
}
