% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{coef.gsl_nls}
\alias{coef.gsl_nls}
\title{Extract model coefficients}
\usage{
\method{coef}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Named numeric vector of fitted coefficients similar to \code{\link[stats]{coef}}
}
\description{
Returns the fitted model coefficients from a \code{"gsl_nls"} object.
\code{coefficients} can also be used as an alias.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
coef(obj)
}
\seealso{
\code{\link[stats]{coef}}
}
