% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddHealth.R
\docType{data}
\name{AddHealth}
\alias{AddHealth}
\title{Add Health data about substance use}
\format{
A data frame with 5114 observations on the following 8 variables.
\describe{
  \item{AID}{A numeric vector of observations' ID.}
  \item{Smoking}{A factor with levels "Yes" or "No"; Have you ever smoked an entire cigarette? }
  \item{Alcohol}{A factor with levels "Yes" or "No";Have you had a drink of beer, wine, or liquor more than two or three times? Do not include sips or tastes from someone else’s drink.}
  \item{Drug}{A factor with levels "Yes" or "No"; Have you ever used any of the following drugs? Other types of illegal drugs, such as LSD, PCP, ecstasy, heroin, or mushrooms; or inhalants. }
  \item{Marijuana}{A factor with levels "Yes" or "No"; Have you ever used any of the following drugs? Marijuana (hash, bhang, ganja) }
  \item{Cocaine}{A factor with levels "Yes" or "No"; Have you ever used any of the following drugs? Cocaine (crack, coca leaves)}
  \item{Gender}{A factor with levels "M" or "F"}
  \item{Edu}{An integer vector from 1 to 8. It refers to the education level.}
}
}
\source{
\href{https://www.icpsr.umich.edu/icpsrweb/ICPSR/studies/21600/datadocumentation#}{ICPSR Add Health}
}
\usage{
data(AddHealth)
}
\description{
Add Health data about substance use
}
\details{
This AddHealth data consist of 5,144 participants' responses with a randomly generated ID variable and five item variables, such as Smoking, Alcohol, Other Types of Illegal Drug, Marijuana, and Cocaine. The responses of the five items are dichotomous as either "Yes" or "No" and are treated the other missing codes as systematic missing. Along with the dichotomous responses, participants' gender and education level are also included in the sample data. This data can be obtained from the National Longitudinal Study of Adolescent to Adult Health (Add Health; Harris et al., 2009) where the study has mainly focused on the investigation of how health factors in childhood affect adult outcomes. In terms of data collection, there have been four additional waves since 1994. In this package, the data of a specific section of substance use at the wave IV is pre-installed.
}
\examples{
data(AddHealth)
str(AddHealth)
head(AddHealth)

}
\references{
Harris, Kathleen Mullan, and Udry, J. Richard. National Longitudinal Study of Adolescent to Adult Health (Add Health), 1994-2008 [Public Use]. Ann Arbor, MI: Carolina Population Center, University of North Carolina-Chapel Hill [distributor], Inter-university Consortium for Political and Social Research [distributor], 2018-08-06. https://doi.org/10.3886/ICPSR21600.v21
}
\keyword{datasets}
