% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_ord.R
\name{design_ord}
\alias{design_ord}
\title{Design the clinical trial for ordinal outcome}
\usage{
design_ord(alpha, beta, K, prob, or0, or, frac)
}
\arguments{
\item{alpha}{Type I error.}

\item{beta}{Type II error.}

\item{K}{Number of treatment arms.}

\item{prob}{Probability of ordinal outcomes in control group.}

\item{or0}{Odds ratio of ineffective treatment group vs control.}

\item{or}{Odds ratio of effective treatment group vs control.}

\item{frac}{Vector of fractions for information time at each look.}
}
\value{
List of cumulative sample size for each stage of treatment and control groups along with maximum total sample size of the trial. It also provides efficacy and futility boundaries of the trial.
}
\description{
This function generates the design parameters of a clinical trial for ordinal outcome.
}
\examples{
design_ord(0.05,0.1,K=4,c(0.075, 0.182, 0.319, 0.243, 0.015, 0.166),or=3.06,or0=1.32,c(1/2,1))
}
